/*
 * Exports.cpp
 *
 *  Created on: Nov 27, 2013
 *      Author: nino
 */

#include <Exports.h>

void export_realization(igraph_vector_t * realization, int realization_id, int source_id, contagion_param_struct *cont_param, char * filePath){



	char file_sufix[100];
	sprintf(file_sufix, "realization_num_%d.txt", realization_id );
	char fileName[150];
	strcpy(fileName, filePath);
	strcat(fileName, file_sufix);

	FILE *fp;
	fp = fopen( fileName,"w");

	if (fp == NULL){
		printf(" Could not open %s \n ",fileName); fflush(stdout);
		exit(-1);
	}


	fprintf(fp,"# source id: %d \n",source_id);
	fprintf(fp,"# p: %lf q: %lf T: %d  \n",cont_param->p, cont_param->q, cont_param->T);
	fprintf(fp,"# node states: \n");

	for(int i=0; i < igraph_vector_size(realization); ++i){
		fprintf(fp,"%d\n", (int) VECTOR( *realization )[i]);
	}
	fclose(fp);

}

void export_source_prob(infected_structure * p_infected_parameters, double * likelihoodsAll, char * filePath, int realization_id, long int sim_num, char * net_file, likelihood_struct * likelihood_tmp, double time_ms){

	//export likelihoods
	char file_sufix[150];
	sprintf(file_sufix, "source_probability_distr_realization_%d_%d_%d_%.5lf_numsim_%010ld.txt", realization_id, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method , likelihood_tmp->likelihood_param.first, sim_num );
	char fileName[200];
	strcpy(fileName, filePath);
	strcat(fileName, file_sufix);

	FILE *fp;
	fp = fopen( fileName,"w");
	fprintf(fp,"# Estimator type %d \n", likelihood_tmp->likelihood_method );
	fprintf(fp,"# Similarity function %d \n", likelihood_tmp->phi_type );
	fprintf(fp,"# Likelihood_param1 %lf \n", likelihood_tmp->likelihood_param.first);
	fprintf(fp,"# Likelihood_param2 %lf \n", likelihood_tmp->likelihood_param.second);
	fprintf(fp,"# Execution time %lf ms , Number of simulations %ld \n", time_ms, sim_num);
	fprintf(fp,"# Network %s \n", net_file);
	fprintf(fp,"# Epidemic origin probability distribution over nodes: \n");

	double norm_sum = 0.0;
	for(int i=0; i < p_infected_parameters->no_of_nodes; ++i){
		//printf("%lf ", likelihoodsAll[i]);
		norm_sum += likelihoodsAll[i];
	}

	//if ( norm_sum == 0.0 ){ // avoid divison by zero
	//	for(int i=0; i < p_infected_parameters->no_of_nodes; ++i){
	//		fprintf(fp,"%.10lf \n", 0.0); //by definition
	//	}
	//}else{
		for(int i=0; i < p_infected_parameters->no_of_nodes; ++i){
			double node_prob = likelihoodsAll[i] / norm_sum;
			fprintf(fp,"%.10lf \n", node_prob);
		}
	//}
	fclose(fp);
}

void output_source_prob_gephi(infected_structure * p_infected_parameters, igraph_vector_t * realization_star, double * likelihoodsAll, int source, int realization_id, char * filePath){

	// output_GDF file format for gephi
	// status: 0-not infected, 1-infected, 2-source
	char file_sufix[50];
	sprintf(file_sufix, "graph_realization_%d.GDF", realization_id );
	char fileName[100];
	strcpy(fileName, filePath);
	strcat(fileName, file_sufix);

	double norm_sum = 0.0;
	for(int i=0; i < p_infected_parameters->no_of_nodes; ++i){
		norm_sum += likelihoodsAll[i];
	}

	FILE *fp1 = fopen(fileName,"w");
	fprintf(fp1, "nodedef>name INT,status INT,score DOUBLE\n");
	for(int i = 0; i< p_infected_parameters->no_of_nodes; ++i){

		double source_prob;
		if (norm_sum = 0.0){ //avoid divison by zero
			source_prob = 0.0; //by definition
		}else{
			source_prob = likelihoodsAll[i] / norm_sum;
		}

		if ( VECTOR(*realization_star)[i] == 0 ){
			// not infected
			fprintf(fp1, "%d,%d,%.2lf\n", i, 0, source_prob);
		}else if ( i == source ){
			// realization source
			fprintf(fp1, "%d,%d,%.2lf\n", i, 2,  source_prob);
		}else{
			// infected but not source
			fprintf(fp1, "%d,%d,%.2lf\n", i, 1,  source_prob);
		}
	}

	fprintf(fp1, "edgedef>node1 INT,node2 INT\n");
	for(int i = 0; i< p_infected_parameters->no_of_nodes; ++i){

			igraph_vector_t *neis;
			int node1 = i;
			neis = igraph_adjlist_get(p_infected_parameters->al, node1);
			igraph_real_t no_of_neigh;
			no_of_neigh = igraph_vector_size(neis);

			for (int j = 0; j < no_of_neigh; ++j) {

					int node2 = (long int) VECTOR(*neis)[j];
					fprintf(fp1, "%d,%d\n", node1, node2);

			}

	}

	fclose(fp1);

}
